package data.scripts.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.util.SWP_Multi;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.entities.AnchoredEntity;

public class SWP_ExcelsiorReactor extends BaseHullMod {

    public static final float BEAM_DAMAGE_REDUCTION = 50f;
    public static final float EMP_DAMAGE_REDUCTION = 50f;
    public static final float OVERLOAD_MULT = 50f;
    public static final float VENT_BONUS = 200f;

    private final IntervalUtil interval = new IntervalUtil(0.1f, 0.1f);

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }

        interval.advance(amount);
        if (ship.getFluxTracker().isOverloaded()) {
            if (interval.intervalElapsed()) {
                if (Math.random() < 0.2) {
                    float shipRadius = SWP_Util.effectiveRadius(ship);

                    Global.getCombatEngine().spawnEmpArc(ship,
                                                         MathUtils.getRandomPointOnCircumference(
                                                                 ship.getLocation(),
                                                                 shipRadius *
                                                                 ((float) Math.random() + 1f)),
                                                         ship, ship, DamageType.ENERGY, 100f, 100f, 500f, null, 15f,
                                                         new Color(255, 150, 200),
                                                         new Color(255, 150, 255));
                }
            }
        } else if (ship.getFluxTracker().isVenting()) {
            if (interval.intervalElapsed()) {
                float scale =
                      ship.getMutableStats().getVentRateMult().getModifiedValue() * 2f / 3f *
                      ship.getMutableStats().getFluxDissipation().getModifiedValue() / 50f;
                if (Math.random() < 0.3 * Math.sqrt(scale)) {
                    float range = (float) Math.sqrt(ship.getFluxTracker().getCurrFlux()) * (float) Math.sqrt(scale) * 4f;
                    List<ShipAPI> targets = AIUtils.getNearbyEnemies(ship, range);
                    if (targets.size() > 0) {
                        ShipAPI target = targets.get(MathUtils.getRandom().nextInt(targets.size()));
                        if (SWP_Multi.isWithinEmpRange(ship.getLocation(), range * 1.25f, target)) {
                            Global.getCombatEngine().spawnEmpArc(ship,
                                                                 MathUtils.getRandomPointOnCircumference(
                                                                         ship.getLocation(), 30f),
                                                                 ship, target,
                                                                 DamageType.ENERGY,
                                                                 70f * scale, 70f * scale, range * 1.25f,
                                                                 "swp_excelsior_vent", 5f * scale,
                                                                 new Color(255, 50, 150), new Color(255, 100, 200));
                        }
                    } else {
                        AnchoredEntity entity = new AnchoredEntity(ship, MathUtils.getRandomPointOnCircumference(
                                                                   ship.getLocation(), 30f));
                        Global.getCombatEngine().spawnEmpArc(ship,
                                                             MathUtils.getRandomPointOnCircumference(
                                                                     ship.getLocation(), range),
                                                             entity, entity,
                                                             DamageType.ENERGY, 0f, 0f, range * 2f, null, 5f * scale,
                                                             new Color(255, 50, 150),
                                                             new Color(255, 100, 200));
                    }
                }
            }
        }
    }

    @Override
    public void applyEffectsBeforeShipCreation(HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getOverloadTimeMod().modifyMult(id, OVERLOAD_MULT / 100f);
        stats.getVentRateMult().modifyPercent(id, VENT_BONUS);
        stats.getEmpDamageTakenMult().modifyPercent(id, -EMP_DAMAGE_REDUCTION);
        stats.getBeamDamageTakenMult().modifyPercent(id, -BEAM_DAMAGE_REDUCTION);
    }

    @Override
    public String getDescriptionParam(int index, HullSize hullSize) {
        if (index == 0) {
            return "" + (int) OVERLOAD_MULT;
        } else if (index == 1) {
            return "" + (int) VENT_BONUS;
        } else if (index == 2) {
            return "" + (int) EMP_DAMAGE_REDUCTION;
        } else if (index == 3) {
            return "" + (int) BEAM_DAMAGE_REDUCTION;
        }
        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return false;
    }
}
